/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.scope;

import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigContextMenu;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigRootNode;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.scope.VWConfigScopeTree;
import filenet.vw.toolkit.design.canvas.config.VWDesignerRegionNode;
import filenet.vw.toolkit.design.canvas.config.VWDesignerVWServiceNode;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class VWScopeTreeMouseAndKeyListener
extends MouseAdapter
implements KeyListener {
    private ActionListener m_listener = null;
    private VWConfigScopeTree m_scopeTree = null;
    private VWConfigBaseNode m_focus = null;
    private VWConfigContextMenu m_mi = null;
    private VWSessionInfo m_vwSessionInfo = null;
    private static Robot robot = null;

    public VWScopeTreeMouseAndKeyListener(ActionListener listener, VWConfigScopeTree scopeTree) {
        this.m_listener = listener;
        this.m_scopeTree = scopeTree;
        this.m_focus = (VWConfigBaseNode)this.m_scopeTree.getModel().getRoot();
        this.m_vwSessionInfo = this.m_focus.getSessionInfo();
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 65: {
                int modifiers = event.getModifiers();
                if ((modifiers & 8) == 0) break;
                this.showPopup(event.getSource(), 10, 10);
                break;
            }
            case 121: {
                int row;
                Rectangle rect;
                JTree tree;
                TreePath path;
                int modifiers = event.getModifiers();
                if ((modifiers & 1) == 0) break;
                robot.keyPress(27);
                robot.keyRelease(27);
                int x = 10;
                int y = 10;
                if (event.getSource() instanceof JTree && (path = (tree = (JTree)event.getSource()).getSelectionPath()) != null && (rect = tree.getRowBounds(row = tree.getRowForPath(path))) != null) {
                    x = rect.x + 2 * rect.width / 3;
                    y = rect.y + 2 * rect.height / 3;
                }
                this.showPopup(event.getSource(), x, y);
                break;
            }
            case 10: {
                this.performAction();
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            Point p = event.getPoint();
            this.showPopup(event.getSource(), p.x, p.y);
        } else {
            int selRow = this.m_scopeTree.getRowForLocation(event.getX(), event.getY());
            if (selRow != -1) {
                this.m_scopeTree.setSelectionRow(selRow);
                this.m_scopeTree.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            Point p = event.getPoint();
            this.showPopup(event.getSource(), p.x, p.y);
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            Point p = event.getPoint();
            if (this.m_scopeTree.getPathForLocation(p.x, p.y) != null) {
                this.performAction();
            }
        }
    }

    protected void setFocus(VWConfigBaseNode node) {
        this.m_focus = node;
    }

    private void showPopup(Object source, int x, int y) {
        String actionCmd = this.m_focus.getActionCommandString();
        if (actionCmd == null) {
            return;
        }
        if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 17, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_CONSOLE_ROOT) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 0, this.m_listener, this.m_focus);
            this.m_mi.setRootMenus((VWConfigRootNode)this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_SYSTEM) == 0) {
            VWConfigVWServiceNode svcNode = (VWConfigVWServiceNode)this.m_focus;
            if (svcNode != null && svcNode instanceof VWDesignerVWServiceNode) {
                return;
            }
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 1, this.m_listener, this.m_focus);
            this.m_mi.setSystemMenus((VWConfigVWServiceNode)this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_REGION) == 0) {
            VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus;
            if (rNode.getSessionInfo() == null) {
                this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 5, this.m_listener, this.m_focus);
            } else {
                this.m_mi = rNode instanceof VWDesignerRegionNode ? new VWConfigContextMenu(rNode.getSessionInfo(), 3, this.m_listener, this.m_focus) : new VWConfigContextMenu(rNode.getSessionInfo(), 2, this.m_listener, this.m_focus);
                this.m_mi.setRegionMenus((VWConfigRegionNode)this.m_focus);
            }
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_SERVER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 4, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_COMP_QUEUE_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 6, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_USER_QUEUE_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 8, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_WORK_QUEUE_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 7, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_WORK_QUEUE) == 0 || VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_USER_QUEUE) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 13, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_COMP_QUEUE) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 12, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_ROSTER_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 9, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_ROSTER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 14, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_EVENTLOG_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 10, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_EVENTLOG) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 15, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_APPSPACE_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 11, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_APPSPACE) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 16, this.m_listener, this.m_focus);
        }
        if (this.m_mi != null) {
            this.m_mi.show((JTree)source, x, y);
        }
    }

    protected void releaseResources() {
        if (this.m_mi != null) {
            this.m_mi.releaseResources();
            this.m_mi = null;
        }
        this.m_listener = null;
        this.m_scopeTree = null;
        this.m_focus = null;
    }

    private void performAction() {
        int nodeType = this.m_focus.getType();
        if (nodeType == 1 || nodeType == 2) {
            this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_QUEUE_PROPERTIES));
        } else if (nodeType == 5) {
            this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_COMPONENT_PROPERTIES));
        } else if (nodeType == 3) {
            this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_ROSTER_PROPERTIES));
        } else if (this.m_focus.getType() == 4) {
            this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_EVENTLOG_PROPERTIES));
        } else if (nodeType == 19) {
            VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus;
            if (rNode.getSessionInfo() == null) {
                this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_LOGON));
            }
        } else if (this.m_focus.getType() == 6) {
            this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_APPSPACE_PROPERTIES));
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    robot = new Robot();
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

